<?php

require 'app/model/area.class.php';
require 'app/model/sede.class.php';
require 'app/model/jornada.class.php';
require 'app/model/grado.class.php';
require 'app/model/periodo.class.php';
require 'app/model/profesor.class.php';
require 'app/model/coordinador.class.php';
require 'app/model/usuario.class.php';
require 'app/model/curso.class.php';
require 'app/model/rango.class.php';
require 'app/model/asignatura.class.php';
require 'app/model/titular.class.php';
require 'app/model/usuario_rol.class.php';

class mvc_controller {
   
	/* METODO QUE RECIBE LA ORDEN DE BUSQUEDA, PREPARA LOS DATOS Y SE COMUNICA
	     CON EL MODELO  PARA REALIZAR LA CONSULTA
		INPUT
		 $carrera | nombre de la carrera a buscar
		 $limit | cantidad de registros a mostrar
		 OUTPUT
		 HTML 	| el resultado obtenido del modelo es procesado y convertido en codigo html para que el VIEW pueda mostrarlo	
	*/

//=========================== USUARIOS_ROLES ==================================

function mostrar_usuarios_roles($inicio,$rol,$codigo)
   {
		$usuario_rol = new usuario_rol();
		//carga la plantilla
		$pagina=$this->load_template('','page_usuario.php');

	   //obtiene  los registros de la base de datos
		  ob_start();

     //Calcula el Total de Areas
       $total_usuarios_roles=$usuario_rol->total_reg($rol,$codigo);

		  //realiza consulta al modelo
		   $tsArray = $usuario_rol->usuarioss_roles($inicio,$rol,$codigo);

        if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos
			   $titulo = 'INGRESAR  USUARIOS';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_usuario_rol.php';

         $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

        }

        $this->view_page($pagina);
   }


  
  
//======================== AREAS ===============================================
    function mostrar_areas($inicio)
   {
		$area = new area();
		//carga la plantilla 
		$pagina=$this->load_template('','page_area.php');

	        //obtiene  los registros de la base de datos
		  ob_start();

                  //Calcula el Total de Areas
                   $total_areas=$area->total_reg();

		  //realiza consulta al modelo
		   $tsArray = $area->areass($inicio);
	   		
                        if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos
			   $titulo = 'INGRESAR AREAS';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_area.php';

                           $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

                        }

                        $this->view_page($pagina);
   }
//=========================== SEDES ============================================
    function mostrar_sedes($inicio)
   {
		$sede = new sede();
		//carga la plantilla
		$pagina=$this->load_template('','page_sede.php');

	        //obtiene  los registros de la base de datos
		  ob_start();

                  //Calcula el Total de Areas
                   $total_sedes=$sede->total_reg();

		  //realiza consulta al modelo
		   $tsArray = $sede->sedess($inicio);

                        if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos
			   $titulo = 'INGRESAR SEDES';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_sede.php';

                           $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

                        }

                        $this->view_page($pagina);
   }
//=========================== PERIODOS ============================================
   function mostrar_periodos($inicio)
   {
		$periodo = new periodo();
		//carga la plantilla
		$pagina=$this->load_template('','page_periodo.php');

	        //obtiene  los registros de la base de datos
		  ob_start();

                  //Calcula el Total de Areas
                   $total_periodos=$periodo->total_reg();

		  //realiza consulta al modelo
		   $tsArray = $periodo->periodoss($inicio);

                        if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos
			   $titulo = 'INGRESAR PERIODOS';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_periodo.php';

                           $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

                        }

                        $this->view_page($pagina);
   }
//=======================  JORNADAS   ==========================================
    function mostrar_jornadas($inicio)
   {
		$jornada = new jornada();
		//carga la plantilla
		$pagina=$this->load_template('','page_jornada.php');

	        //obtiene  los registros de la base de datos
		  ob_start();

                  //Calcula el Total de Areas
                   $total_jornadas=$jornada->total_reg();

		  //realiza consulta al modelo
		   $tsArray = $jornada->jornadass($inicio);

                        if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos
			   $titulo = 'INGRESAR JORNADAS';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_jornada.php';

                           $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

                        }

                        $this->view_page($pagina);
   }
//=========================== GRADOS ============================================
    function mostrar_grados($inicio)
   {
		$grado = new grado();
		//carga la plantilla
		$pagina=$this->load_template('','page_grado.php');

	        //obtiene  los registros de la base de datos
		  ob_start();

                  //Calcula el Total de Areas
                   $total_grados=$grado->total_reg();

		  //realiza consulta al modelo
		   $tsArray = $grado->gradoss($inicio);

                        if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos
			   $titulo = 'INGRESAR GRADOS';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_grado.php';

                           $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

                        }

                        $this->view_page($pagina);
   }
//=========================== PROFESORES ============================================
    function mostrar_profesores($inicio)
   {
		$profesor = new profesor();
		//carga la plantilla
		$pagina=$this->load_template('','page_profesor.php');

	        //obtiene  los registros de la base de datos
		  ob_start();

                  //Calcula el Total de Areas
                   $total_profesores=$profesor->total_reg();

		  //realiza consulta al modelo
		   $tsArray = $profesor->profesoress($inicio);

                        if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos
			   $titulo = 'INGRESAR PROFESORES';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_profesor.php';

                           $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

                        }

                        $this->view_page($pagina);
   }
   
//=========================== COORDINADORES ============================================
    
    function mostrar_coordinadores($inicio)
   {
		$coordinador = new coordinador();
		//carga la plantilla
		$pagina=$this->load_template('','page_coordinador.php');

	    //obtiene  los registros de la base de datos
		  ob_start();

      //Calcula el Total de Areas
      $total_coordinadores=$coordinador->total_reg();

		  //realiza consulta al modelo
		   $tsArray = $coordinador->coordinadoress($inicio);

       if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos
			   $titulo = 'INGRESAR COORDINADORES';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_coordinador.php';

         $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

         }

         $this->view_page($pagina);
   }
      
//=========================== USUARIOS ============================================
    
    function mostrar_usuarios($inicio)
   {
		$usuario = new usuario();
		//carga la plantilla
		$pagina=$this->load_template('','page_usuario.php');

	    //obtiene  los registros de la base de datos
		  ob_start();

      //Calcula el Total de Areas
      $total_usuarios=$usuario->total_reg();

		  //realiza consulta al modelo
		   $tsArray = $usuario->usuarioss($inicio);

       if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos
			   $titulo = 'INGRESAR USUARIO';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_usuario.php';

         $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

         }

         $this->view_page($pagina);
   }

   
//=========================== CURSOS ============================================
function mostrar_cursos($inicio)
   {
		$curso = new curso();
		//carga la plantilla
		$pagina=$this->load_template('','page_curso.php');

	        //obtiene  los registros de la base de datos
		  ob_start();

                  //Calcula el Total de Areas
                   $total_cursos=$curso->total_reg();

		  //realiza consulta al modelo
		   $tsArray = $curso->cursoss($inicio);

                        if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos
			   $titulo = 'INGRESAR CURSOS';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_curso.php';

                           $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

                        }

                        $this->view_page($pagina);
   }

//=========================== RANGOS ============================================

function mostrar_rangos($inicio)
   {
		$rango = new rango();
		//carga la plantilla
		$pagina=$this->load_template('','page_rango.php');

	        //obtiene  los registros de la base de datos
		  ob_start();

                  //Calcula el Total de Areas
                   $total_rangos=$rango->total_reg();

		  //realiza consulta al modelo
		   $tsArray = $rango->rangoss($inicio);

                        if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos
			   $titulo = 'INGRESAR RANGO DE VALORACIONES';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_rango.php';

                           $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

                        }

                        $this->view_page($pagina);
   }

//=========================== ASIGNATURAS ============================================

function mostrar_asignaturas($inicio)
   {
		$asignatura = new asignatura();
		//carga la plantilla
		$pagina=$this->load_template('','page_asignatura.php');

	        //obtiene  los registros de la base de datos
		  ob_start();

                  //Calcula el Total de Areas
                   $total_asignaturas=$asignatura->total_reg();

		  //realiza consulta al modelo
		   $tsArray = $asignatura->asignaturass($inicio);

                        if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos
			   $titulo = 'INGRESAR  ASIGNATURAS';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_asignatura.php';

                           $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

                        }

                        $this->view_page($pagina);
   }

//=========================== TITULARES ============================================

function mostrar_titulares($inicio)
   {
		$titular = new titular();
		//carga la plantilla
		$pagina=$this->load_template('','page_titular.php');

	        //obtiene  los registros de la base de datos
		  ob_start();

                  //Calcula el Total de Areas
                   $total_titulares=$titular->total_reg();

		  //realiza consulta al modelo
		   $tsArray = $titular->titularess($inicio);

                        if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos
			   $titulo = 'INGRESAR  TITULARES';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_titular.php';

                           $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

                        }

                        $this->view_page($pagina);
   }


//==============================================================================

   /* METODO QUE MUESTRA LA PAGINA PRINCIPAL CUANDO NO EXISTEN NUEVAS ORDENES
   OUTPUT
   HTML | codigo html de la pagina   
   */
   function principal()
   {
		$pagina=$this->load_template('','page.php');
		$html = $this->load_page('app/views/default/modules/m.principal.php');
		$pagina = $this->replace_content('/\#CONTENIDO\#/' ,$html , $pagina);
		$this->view_page($pagina);
   }
//==============================================================================
	/* METODO QUE CARGA LAS PARTES PRINCIPALES DE LA PAGINA WEB
	INPUT
		$title | titulo en string del header
	OUTPIT
		$pagina | string que contiene toda el cocigo HTML de la plantilla 
	*/
	function load_template($title='',$page=''){
		$pagina = $this->load_page('app/views/default/'.$page);
		$header = $this->load_page('app/views/default/sections/s.header.php');
		$pagina = $this->replace_content('/\#HEADER\#/' ,$header , $pagina);
		$pagina = $this->replace_content('/\#TITLE\#/' ,$title , $pagina);
		$menu_left = $this->load_page('app/views/default/sections/s.menuizquierda.php');
		$pagina = $this->replace_content('/\#MENULEFT\#/' ,$menu_left , $pagina);
		return $pagina;
	}
//==============================================================================
	/* METODO QUE CARGA UNA PAGINA DE LA SECCION VIEW Y LA MANTIENE EN MEMORIA
		INPUT
		$page | direccion de la pagina 
		OUTPUT
		STRING | devuelve un string con el codigo html cargado
	*/	
	private function load_page($page)
	{
		return file_get_contents($page);
	}
//==============================================================================
	/* METODO QUE ESCRIBE EL CODIGO PARA QUE SEA VISTO POR EL USUARIO
		INPUT
		$html | codigo html
		OUTPUT
		HTML | codigo html		
	*/
	private function view_page($html)
	{
		echo $html;
	}
//==============================================================================  
	/* PARSEA LA PAGINA CON LOS NUEVOS DATOS ANTES DE MOSTRARLA AL USUARIO
		INPUT
		$out | es el codigo html con el que sera reemplazada la etiqueta CONTENIDO
		$pagina | es el codigo html de la pagina que contiene la etiqueta CONTENIDO
		OUTPUT
		HTML 	| cuando realiza el reemplazo devuelve el codigo completo de la pagina
	*/
        private function replace_content($in='/\#CONTENIDO\#/', $out,$pagina)
	{
		 return preg_replace($in, $out, $pagina);	 	
	}
	
}
?>