<?php

require_once "../app/model/db.class.php";
require 'app/model/tiposfalta.class.php';
require 'app/model/clasesdefalta.class.php';
require 'app/model/faltapersonal.class.php';
require 'app/model/busdefaltaper.class.php';

require 'app/model/mostrar_faltas.class.php';

class mvc_controller {
   
	/* METODO QUE RECIBE LA ORDEN DE BUSQUEDA, PREPARA LOS DATOS Y SE COMUNICA
	     CON EL MODELO  PARA REALIZAR LA CONSULTA
		INPUT
		 $carrera | nombre de la carrera a buscar
		 $limit | cantidad de registros a mostrar
		 OUTPUT
		 HTML 	| el resultado obtenido del modelo es procesado y convertido en codigo html para que el VIEW pueda mostrarlo	
	*/

//=========================== TIPOS DE FALTA ====== oJO    ======================

    function mostrar_clasfalta($inicio){

		$t_faltas = new t_faltas();
		//carga la plantilla
		$pagina=$this->load_template('','page_tposfalta.php');

	        //obtiene  los registros de la base de datos
		  ob_start();

                  //Calcula el Total de Areas
                   $total_tpsofalta=$t_faltas->total_reg();
                   
		  //realiza consulta al modelo
		   $tsArray = $t_faltas->faltas_tip($inicio);

                        if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos
			   $titulo = 'DESCRIPCION DE FALTAS';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_tfalta.php';
                            
                           $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

                        }else{
                            $titulo = 'CLASES DE FALTA';
			   include 'app/views/default/modules/m.table_tfalta_ini.php';
                            
                           $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);
                        }

                        $this->view_page($pagina);
   }
   

   //=========================== BUSCAR DESCRIPCION DE FALTAS ========= Mario ========

   function buscar_clases_faltas($inicio,$tipo){

                //echo $inicio." - ".$codigo." - ".$periodo;
		$faltas = new buscar_faltas();
		//carga la plantilla
		$pagina=$this->load_template('','page_tposfalta.php');

	        //obtiene  los registros de la base de datos
		  ob_start();

                  //Calcula el Total de Registros
                   $total_tpsofalta=$faltas->total_f($tipo);
                    if($total_tpsofalta==0)
                   {
                       $pagina = $this->replace_content('/\#CONTENIDO\#/', "<h2>No hay Registros....</h2> " , $pagina);
                       echo '<meta http-equiv="refresh" content="2; url=ingresar_f.php?action=mostrar_falta" />';
                   }

                    if($total_tpsofalta>=1 and $total_tpsofalta<10)
                   {
                   $inicio=0;
                   }


		  //realiza consulta al modelo
                   $tsArray = $faltas->buscar_f($inicio,$tipo);

                        if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos
			   $titulo = 'DESCRIPCION DE FALTAS';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_mostrar_clases.php';

                           $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

                        }

                        $this->view_page($pagina);
   }




//=========================== CLASES DE FALTA ============================================

   function mostrar_tposfalta($inicio)
   {            
		$t_faltas = new cl_faltas();
		//carga la plantilla
		$pagina=$this->load_template('','page_clasesfalta.php');

	        //obtiene  los registros de la base de datos
		  ob_start();

                  //Calcula el Total de Areas
                   $total_tpsofalta=$t_faltas->total_reg();
                   
		  //realiza consulta al modelo
		   $tsArray = $t_faltas->faltascls($inicio);

                        if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos
			   $titulo = 'TIPOS DE FALTA';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_clasfalta.php';

                           $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

                        }else{
                            $titulo = 'TIPOS DE FALTA';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_clasfalta_ini.php';

                           $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);
                        }

                        $this->view_page($pagina);
   } 
   
//=========================== FALTA ALUMNO ============================================
   
    function mostrar_faltas_alumnos($inicio){
                
		$t_faltas = new faltas_per();
		//carga la plantilla
		$pagina=$this->load_template('','page_faltaPer.php');

	        //obtiene  los registros de la base de datos
		  ob_start();

                  //Calcula el Total de Areas
                   $total_tpsofalta=$t_faltas->total_reg();
                   
		  //realiza consulta al modelo
		   $tsArray = $t_faltas->per_cfaltas($inicio);

                        if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos
			   $titulo = 'FALTAS PERSONALES';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_faltaper.php';

                           $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

                        }else{
                             $titulo = 'FALTAS PERSONALES';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_faltaper_ini.php';

                           $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);
                        }

                        $this->view_page($pagina);
   }    

//=========================== BUSQUEDA FALTA ALUMNO ============================================

   function busqueda_faltas_alumnos($inicio,$codigo,$periodo)
   {
                //echo $inicio." - ".$codigo." - ".$periodo;
		$t_faltas = new busqper_faltas();
		//carga la plantilla
		$pagina=$this->load_template('','page_faltaPer.php');

	        //obtiene  los registros de la base de datos
		  ob_start();

                  //Calcula el Total de Areas
                   $total_tpsofalta=$t_faltas->total_regper($codigo,$periodo);
                    if($total_tpsofalta==0)
                   {
                       $pagina = $this->replace_content('/\#CONTENIDO\#/', "<h2>No hay Registros....</h2> " , $pagina);
                       echo '<meta http-equiv="refresh" content="2; url=ingresar_f.php?action=alumn_rport_falt" />';
                   }

                    if($total_tpsofalta>=1 and $total_tpsofalta<10)
                   {
                   $inicio=0;
                   }


		  //realiza consulta al modelo
		   $tsArray = $t_faltas->busper_cfaltas($inicio,$codigo,$periodo);

                        if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos
			   $titulo = 'REPORTE FALTAS PERSONALES';
			   //carga la tabla de la seccion de VIEW
			   include 'app/views/default/modules/m.table_bus_faltaper.php';

                           $table = ob_get_clean();
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

                        }

                        $this->view_page($pagina);
   }

  
   //=========================== BUSQUEDA FALTAS ===============================
    
      function busqueda_faltas_grupo($grado,$curso)
   {            
		$t_faltas = new res_busqgrup_faltas();
		//carga la plantilla
		$pagina=$this->load_template('','page_faltagroup.php');

	        //obtiene  los registros de la base de datos
		  ob_start();

                  //Calcula el Total de Areas
                   $total_tpsofalta=$t_faltas->total_reggro($grado,$curso);
                   if($total_tpsofalta==0)
                   {
                       
                   }else{
		  //realiza consulta al modelo
		   $tsArray = $t_faltas->grup_cfaltas($grado,$curso);

                        if($tsArray!=''){       //si existen registros carga el modulo  en memoria y rellena con los datos*/
			   $titulo = 'FALTAS PERSONALES';
			   //carga la tabla de la seccion de VIEW
			   

                           $table = $this->load_page('app/views/default/modules/m.table_mengrup.php');
			   //realiza el parseado
			   $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);

                   }

                   $this->view_page($pagina);}
   }    
   
   //=========================== PDF ============================================
    function pdf(){            
    $pagina=$this->load_template('','page_pdf.php');
    $table=  $this->load_page('app/views/default/modules/m.mepdf.php');

    $pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);
    $this->view_page($pagina);
   }    
   


//==============================================================================

   /* METODO QUE MUESTRA LA PAGINA PRINCIPAL CUANDO NO EXISTEN NUEVAS ORDENES
   OUTPUT
   HTML | codigo html de la pagina   
   */
   function principal()
   {
		$pagina=$this->load_template('','menu.php');
		$html = $this->load_page('app/views/default/modules/m.principal.php');
		$pagina = $this->replace_content('/\#CONTENIDO\#/' ,$html , $pagina);
		$this->view_page($pagina);
   }
//==============================================================================
	/* METODO QUE CARGA LAS PARTES PRINCIPALES DE LA PAGINA WEB
	INPUT
		$title | titulo en string del header
	OUTPIT
		$pagina | string que contiene toda el cocigo HTML de la plantilla 
	*/
	function load_template($title='',$page=''){
		$pagina = $this->load_page('app/views/default/'.$page);
		$header = $this->load_page('app/views/default/sections/s.header.php');
		$pagina = $this->replace_content('/\#HEADER\#/' ,$header , $pagina);
		$pagina = $this->replace_content('/\#TITLE\#/' ,$title , $pagina);
		$menu_left = $this->load_page('app/views/default/sections/s.menuizquierda.php'); 
		$pagina = $this->replace_content('/\#MENULEFT\#/' ,$menu_left , $pagina);
		return $pagina;
	}
//==============================================================================
	/* METODO QUE CARGA UNA PAGINA DE LA SECCION VIEW Y LA MANTIENE EN MEMORIA
		INPUT
		$page | direccion de la pagina 
		OUTPUT
		STRING | devuelve un string con el codigo html cargado
	*/	
	private function load_page($page)
	{
		return file_get_contents($page);
	}
//==============================================================================
	/* METODO QUE ESCRIBE EL CODIGO PARA QUE SEA VISTO POR EL USUARIO
		INPUT
		$html | codigo html
		OUTPUT
		HTML | codigo html		
	*/
	private function view_page($html)
	{
		echo $html;
	}
//==============================================================================  
	/* PARSEA LA PAGINA CON LOS NUEVOS DATOS ANTES DE MOSTRARLA AL USUARIO
		INPUT
		$out | es el codigo html con el que sera reemplazada la etiqueta CONTENIDO
		$pagina | es el codigo html de la pagina que contiene la etiqueta CONTENIDO
		OUTPUT
		HTML 	| cuando realiza el reemplazo devuelve el codigo completo de la pagina
	*/
        private function replace_content($in='/\#CONTENIDO\#/', $out,$pagina)
	{
		 return preg_replace($in, $out, $pagina);	 	
	}
	
}
?>